function plot_2sidedChart_v3(x,y1,y2,NameYlabel,TITOLO,SPESSORE,Limiti)


% Create a plot with 2 y axes using the plotyy function
fig = figure;
[ax, h1, h2] = plotyy(x, y1, x, y2, 'plot');

% Add title and x axis label
title(TITOLO);

% Use the axis handles to set the labels of the y axes
% set(get(ax(1), 'Ylabel'), 'String', NameYlabel{1});
% set(get(ax(2), 'Ylabel'), 'String', NameYlabel{2});
legend1 = legend(NameYlabel{1},NameYlabel{2}); 
set(legend1,'Edgecolor',[1 1 1],'location','best');
legend('boxoff');

% Set limits
set(ax(1), 'Xlim', [min(x) max(x)]);
set(ax(2), 'Xlim', [min(x) max(x)]);


if nargin<7 
    CUT = 3.5; 
    Ylim1 = [mean(y1)-CUT*std(y1) mean(y1)+CUT*std(y1)]; 
    Ylim2 = [mean(y2)-CUT*std(y2) mean(y2)+CUT*std(y2)]; 
    Step1 = [round(Ylim1(1)-.1,1):round((Ylim1(2) - Ylim1(1))/5,2):round(Ylim1(2)+.1,1)]; 
    Step2 = [round(Ylim2(1)-.1,1):round((Ylim2(2) - Ylim2(1))/5,2):round(Ylim2(2)+.1,1)]; 
else 
    Ylim1 = [Limiti(1,1) Limiti(1,2)]; 
    Ylim2 = [Limiti(2,1) Limiti(2,2)]; 
    Step1 = [round(Ylim1(1)):round((Ylim1(2) - Ylim1(1))/5):round(Ylim1(2))]; 
    Step2 = [round(Ylim2(1)):round((Ylim2(2) - Ylim2(1))/5):round(Ylim2(2))]; 

end
    

set(ax(1), 'Ylim', Ylim1,'YTick',[Step1]);
set(ax(2), 'Ylim', Ylim2,'YTick',[Step2]);



% Change Formatting 
set(h1,'linewidth',SPESSORE);
set(h2,'linewidth',SPESSORE,'linestyle','--');

set(gca,'Xtick',x); 
% datetick('x','yyyy','keepticks'); 
datetick('x','yyyy','keeplimits');
grid('on');
recessionplot; 

%--PLOTLY--%

% Strip MATLAB style by default!
% response = fig2plotly(fig, 'filename', 'matlab-two-axes-plot-style');
% plotly_url = response.url;